﻿using System;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class GetAppointmentTypeStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (state.CrmAppointment != null)
                state.AppointmentType = AppointmentType.GROUP;
            else if (state.ServiceAppointment.cvt_Type.Value)
                state.AppointmentType = AppointmentType.HOME_MOBILE;
            else if (state.ServiceAppointment.cvt_TelehealthModality.HasValue && state.ServiceAppointment.cvt_TelehealthModality.Value)
                state.AppointmentType = AppointmentType.STORE_FORWARD;
            else
                state.AppointmentType = AppointmentType.CLINIC_BASED;
        }
    }
}
